//	TorusGamesLanguageChoiceController.h
//
//	© 2021 by Jeff Weeks
//	See TermsOfUse.txt

#import <UIKit/UIKit.h>
#import "GeometryGamesPopover.h"
#import "GeometryGames-Common.h"	//	for Char16

@protocol TorusGamesLanguageChoiceDelegate
- (BOOL)prefersStatusBarHidden;
- (void)userDidChooseLanguage:(const Char16 [3])aTwoLetterLanguageCode;
- (void)userDidCancelLanguageChoice;
@end

@interface TorusGamesLanguageChoiceController : UITableViewController
	<UITableViewDataSource, UITableViewDelegate, GeometryGamesPopover>

- (id)initWithDelegate:(id<TorusGamesLanguageChoiceDelegate>)aDelegate languageChoice:(const Char16 [3])aTwoLetterLanguageCode;
- (BOOL)prefersStatusBarHidden;
- (void)viewWillAppear:(BOOL)animated;

//	GeometryGamesPopover
- (void)adaptNavBarForHorizontalSize:(UIUserInterfaceSizeClass)aHorizontalSizeClass;

//	UITableViewDataSource
- (NSInteger)numberOfSectionsInTableView:(UITableView *)aTableView;
- (NSString *)tableView:(UITableView *)aTableView titleForHeaderInSection:(NSInteger)aSection;
- (NSInteger)tableView:(UITableView *)aTableView numberOfRowsInSection:(NSInteger)aSection;
- (UITableViewCell *)tableView:(UITableView *)aTableView cellForRowAtIndexPath:(NSIndexPath *)anIndexPath;

//	UITableViewDelegate
- (NSIndexPath *)tableView:(UITableView *)aTableView willSelectRowAtIndexPath:(NSIndexPath *)anIndexPath;

@end
